using System;
using System.Collections;
using Server.Misc;
using Server.Items;
using Server.Spells.Spellweaving;
using Server.Network;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "an ophidian corpse" )]
	public class IceOphidianWarrior : OphidianWarrior
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.WhirlwindAttack;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.BleedAttack;
			}
		}
      
      [Constructable]
		public IceOphidianWarrior() : base()
		{
         Hue = 194;
			Name = "ophidiansky valecnik";
         
			SetStr( 505, 700 );
			SetDex( 202, 300 );
			SetInt( 502, 600 );

			SetHits( 2000, 2100 );
			SetStam( 305, 600 );
			SetMana( 800, 1000 );

			SetDamage( 25, 30 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 60, 80 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 80 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.MagicResist, 90.7, 140.0 );
			SetSkill( SkillName.Tactics, 97.6, 110.0 );
			SetSkill( SkillName.Wrestling, 100.6, 120.0 );
			SetSkill( SkillName.Anatomy, 97.6, 100.0 );
			SetSkill( SkillName.Magery, 80.0, 110.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Poisoning, 120.1, 140.0 );
			SetSkill( SkillName.Spellweaving, 110.1, 120.0 );
			
			Fame = 6000;
			Karma = -9500;

			VirtualArmor = 80;
			Tamable = false;
         
			PackItem( new Bandage( Utility.RandomMinMax( 20, 30 ) ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Miscellaneous );
			AddLoot( LootPack.Gems, Utility.RandomMinMax( 2, 6 ) );
		}

		public override int Meat{ get{ return 1; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
      
		public override void OnDamagedBySpell( Mobile attacker )
		{
			if ( 0.6 > Utility.RandomDouble() && !attacker.InRange( this, 1 ) )
			{
				int effId = 3917;
				
				Effects.SendPacket( attacker, attacker.Map, new HuedEffect( EffectType.Moving, Serial.Zero, Serial.Zero, effId, this.Location, attacker.Location, 10, 0, false, false, 0, 0 ) );
				AOS.Damage( attacker, this, Utility.RandomMinMax( 70, 125 ), 50, 0, 0, 0, 50 );
			}
			else
				base.OnDamagedBySpell( attacker );
		}
      
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && Utility.RandomDouble() < 0.025 )
			{
				switch ( Utility.Random( 3 ) )
				{
					case 0:
						{
							new AttunementSpell( this, null ).Cast();
						}
						break;
					case 1:
						{
							new ImmolatingWeaponSpell( this, null ).Cast();
						}
						break;
					case 2:
						{
							this.BandageSelf();
							this.Emote( "* begin apllying bandages *" );
						}
						break;
				}
			}
			base.OnActionCombat();
		}
      
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if (from == null)
				return;
			
			if ( Utility.RandomDouble() < 0.01 && from.Player )
			{
				KhalAnkur.Waller( 3, 8, from );
			}
		}
		
		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.TerathansAndOphidians; }
		}

		public IceOphidianWarrior( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}